/*
 * dgram_service.h
 *
 * Definitions for Inter Node Communication - datagram service
 *
 *   Copyright (C) 2015 Jiada Wang <jiada_wang@mentor.com>
 *   Copyright (C) 2015 Mentor Graphics
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation, and
 * that the name of the copyright holders not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no representations
 * about the suitability of this software for any purpose.  It is provided "as
 * is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

#ifndef DGRAM_SERVICE__H
#define DGRAM_SERVICE__H

#define AF_INC		41

/* standard header for datagram service */
struct dgram_header_std {
	/* 2byte-length of dgram */
	unsigned short dglen;
};

#define DGRAM_MAX (0xffff - sizeof(struct dgram_header_std))

#ifdef DEBUG
#define debug_print(fmt, args...)    fprintf(stderr, fmt, ## args)
#else
#define debug_print(fmt, args...)    /* Don't do anything in release builds */
#endif

struct sk_dgram {
	int sk;
	char *buf;
	int len;
	int proto;
	int hlen;
	int received;
	struct dgram_header_std h;
};

int dgram_recv(struct sk_dgram *, void *, int);
int dgram_send(struct sk_dgram *, void *, int);
void dgram_exit(struct sk_dgram *);
struct sk_dgram *dgram_init(int, int, int);

#endif
